package gov.va.med.mhv.health.validator;

import gov.va.med.mhv.health.dto.MedicalEventDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.util.MessagesUtil;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MedicalEventValidator extends Validator{
	
	
	private static final int COMMENTS_MAX_LENGTH = 255;
	private static final int MEDICALEVENT_MIN_LENGTH = 2;
	private static final int MEDICALEVENT_MAX_LENGTH = 50;
	private static final int RESPONSE_MAX_LENGTH = 255;
	private static final String COMMENTS="Comments";

	
	@Autowired
	private MessagesUtil messages;

	
	public void medicalEventValidations(ResponseUtil response, MedicalEventDTO medicalEventDTO) {
		fieldValidation(response, medicalEventDTO);
		if (response.getValidationErrors().size() == 0) {
			complexValidation(response, medicalEventDTO);
		}
	}

	private void fieldValidation(ResponseUtil response,	MedicalEventDTO medicalEventDTO) {
		validateComments(response,medicalEventDTO);
		validateStopDate(response,medicalEventDTO);
		validateMedicalEvent(response,medicalEventDTO);
		validateStartDate(response,medicalEventDTO);
		validateResponse(response,medicalEventDTO);
		validateUserProfile(response,medicalEventDTO);

	}

	private void validateUserProfile(ResponseUtil response,	MedicalEventDTO medicalEventDTO) {
		if( medicalEventDTO.getUserprofileId() == null ) {
			response.getValidationErrors().put("userProfile", "userProfile is required");
			return;
		}
		boolean valid= isUserProfileValid(medicalEventDTO.getUserprofileId());
		if ( !valid) {
			response.getValidationErrors().put("userProfile", "userProfile is Invalid");
		}
	}

	private void validateStartDate(ResponseUtil response,MedicalEventDTO medicalEventDTO) {
		Date value = medicalEventDTO.getStartDate();
		if ( value == null ) {
			Validations.validateRequired("Start Date", value, response.getValidationErrors());
			return;
		}						
	}

	private void validateMedicalEvent(ResponseUtil response,MedicalEventDTO medicalEventDTO) {
		String value = medicalEventDTO.getMedicalEvent();
		if( value == null ) {
			response.getValidationErrors().put("Medical Event", " Medical Event is a required field.");
			return;
		}	
		
		Validations.validateMinLength("Medical Event minumum",value, MEDICALEVENT_MIN_LENGTH, response.getValidationErrors());
		Validations.validateMaxLength("Medical Event maximum",value, MEDICALEVENT_MAX_LENGTH, response.getValidationErrors());
	}

	private void validateComments(ResponseUtil response,MedicalEventDTO medicalEventDTO) {
		String value = medicalEventDTO.getComments();
		if ( value == null ) {
			return;
		}						
		Validations.validateMaxLength(COMMENTS,value, COMMENTS_MAX_LENGTH, response.getValidationErrors());
	}

	private void validateStopDate(ResponseUtil response,MedicalEventDTO medicalEventDTO) {
		Date value = medicalEventDTO.getStopDate();
		if ( value == null ) {
			return;
		}						
	}

	private void validateResponse(ResponseUtil response,MedicalEventDTO medicalEventDTO) {
		String value = medicalEventDTO.getResponse();
		if ( value == null ) {
			return;
		}						
		Validations.validateMaxLength("Response",value, RESPONSE_MAX_LENGTH, response.getValidationErrors());
	}

	private void complexValidation(ResponseUtil response,MedicalEventDTO medicalEventDTO) {
		if ( medicalEventDTO.getStartDate() != null  && medicalEventDTO.getStopDate() != null ) {
			if (!medicalEventDTO.getStartDate().before(medicalEventDTO.getStopDate()) && 
				!medicalEventDTO.getStartDate().equals(medicalEventDTO.getStopDate())) {
				response.getValidationErrors().put("startDate.before.stopDate",	messages.getInvalidStartStopDate());
			}
		}
	}
}
